; to use this, install AutoHotkey (which is free), and run the script either by dragging it onto the AutoHotkey program file or double-clicking it (if it's associated with AutoHotkey, which it probably should be)
; then, run Dominions 3 with the animated backgrounds turned off, and load a game
; press F1 to view all provinces and commanders, find a commander you'd like to have gather all the blood slaves (in a province with no lab; if there's a lab you may as well use the game's own keyboard shortcut), bring up that commander's detailed description, and press the hotkey defined below (z by default)
; if the numbers in the script below are all adjusted properly, then the other commanders' blood slaves will be rapidly given to the selected commander (note:  on first use, the script may just resize your game window instead of transferring slaves)
; finally, close or suspend AutoHotkey

; (if the numbers in the script are not adjusted to your liking, then you should either refrain from using it further, or readjust them yourself; they're associated with names that should give a strong hint about what they're supposed to mean, so the task of adjusting them, though somewhat difficult, might not be entirely frustrating, though it's up to you whether it'd be worthwhile)
; (a further note regarding UI element positions:  it's conceivable that all of them other than targetWindowWidth and targetWindowHeight could be defined in terms of those two values, so that changing one of those would not break the rest of the script...  for the moment this is left as an exercise for the user, because the present author doesn't know whether it'd work reliably across different computers, or whether enough people would be interested to warrant the work)

; version #:  0.1

z:: ; the hotkey is the text before the colons, and may be changed to most any character, plus optional modifiers
    ; for instance, b here (before the colons) means b (instead of z), +z here means Z, ^z means ctrl-z, ! means alt-z, a&z means a and z together, <!z means left-alt-z, #z means Windows-key-z, etc. (see the AutoHotkey documentation for more details)

IfWinExist Dominions 3
{
	WinActivate

	targetWindowWidth := 1030
	targetWindowHeight := 800

	WinGetPos,,, windowWidth, windowHeight

	if (windowWidth != targetWindowWidth)
		if (windowHeight != targetWindowHeight)
		{
			WinMove,,,,, %targetWindowWidth%, %targetWindowHeight% ; resize the window
			return ; the game won't be ready for the script any more, so let the user try again
		}

	windowMiddleX := 515
	windowMiddleY := 400
	windowBottomY := 800

	unitDescriptionNearRightEndX := 775
	unitDescriptionNearLeftEndX := 241
	unitDescriptionNearTopY := 220
	unitDescriptionNearMiddleY := 342

	PixelSearch dummyX, descriptionTopY, unitDescriptionNearRightEndX, unitDescriptionNearTopY, unitDescriptionNearRightEndX, 0, 0x000000 ; find the top of the unit description by searching upward for black
	PixelSearch descriptionLeftX, dummyY, unitDescriptionNearLeftEndX, unitDescriptionNearMiddleY, 0, unitDescriptionNearMiddleY, 0x000000 ; find the left side of the unit description by searching leftward for black
	personalGemsX := descriptionLeftX + 320
	personalGemsY := descriptionTopY + 240
	Click %personalGemsX%, %personalGemsY%

	slaveCountX := 420
	slaveCountY := 490
	PixelSearch magicResourcesLeftX, dummyY, slaveCountX, slaveCountY, 0, slaveCountY, 0x000000 ; find the left side of the magic resources interface by searching leftward for black

	BringUpCommanderSelectionMenu() ; bring up this menu just for the purpose of finding its bottom
	commanderMenuCenterX := 518
	PixelSearch dummyX, commanderMenuBottomY, commanderMenuCenterX, windowMiddleY, commanderMenuCenterX + 1, windowBottomY, 0x000000 ; find the bottom of the commander selection menu by searching downward for black

	commanderNameX := commanderMenuCenterX - 108
	commanderNameY := commanderMenuBottomY - 69
	commanderNameSeparationY := 30

	Click %commanderNameX%, %commanderNameY% ; select a commander to return to the slave transfer screen

	while commanderNameY > 0 ; try to transfer slaves from all commanders (including the originally selected one--oh well)
	{
		BringUpCommanderSelectionMenu()
		Click %commanderNameX%, %commanderNameY% ; select the next commander (this starts with the bottommost one)
		commanderNameY -= %commanderNameSeparationY%

		PixelGetColor colorJustWithinMagicResourcesArea, magicResourcesLeftX + 1, slaveCountY
		if (colorJustWithinMagicResourcesArea = 0x000000) ; if the area that contained the magic resources interface is presently empty, then the commander selection menu must still be up--this means the iteration has passed the last commander and there is no need to proceed further
			break

		ClickManyTimes(slaveCountX, slaveCountY) ; transfer slaves from that commander to the originally selected one
	}

	ClickExit(windowMiddleX, windowBottomY, windowMiddleY) ; exit the commander selection menu
	ClickExit(windowMiddleX, windowBottomY, windowMiddleY) ; exit the magical resources interface
	ClickExit(windowMiddleX, windowBottomY, windowMiddleY) ; exit the description of the originally selected commander
}
else
{
	MsgBox Error:  A window with a title starting with "Dominions 3" wasn't found.  (If you don't intend to use this script, then please unload it from AutoHotkey, or close AutoHotkey altogether.)
}

BringUpCommanderSelectionMenu()
{
	Click 498, 243
}

ClickManyTimes(x, y)
{
	loop 14 ; decrease this number for greater speed; increase it for greater correctness
		Click %x%, %y%
}

ClickExit(windowMiddleX, windowBottomY, windowMiddleY)
{
	PixelSearch dummyX, menuBottomY, windowMiddleX, windowMiddleY, windowMiddleX, windowBottomY, 0x000000 ; find the bottom of the currently open menu by searching downward for black
	exitFromMenuBottomY := 38
	exitButtonY := menuBottomY - exitFromMenuBottomY
	Click %windowMiddleX%, %exitButtonY%
}